let tabPanelStates = new Map();
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'openSidePanel') {
    const tabId = sender.tab?.id;
    if (!tabId) return;
    
    // 保存当前标签页的内容和检测结果
    tabPanelStates.set(tabId, {
      text: request.text,
      isTextarea: request.isTextarea,
      resultList: request.resultList || [],
      resultListAll: request.resultListAll || [],
      statisticsList: request.statisticsList || [],
      hasContent: true,
      checked: false // 标记是否已经检测过
    });
    
    chrome.sidePanel.open({ windowId: sender.tab.windowId })
      .then(() => {
        setTimeout(() => {
          // 发送当前标签页对应的内容到侧板
          chrome.runtime.sendMessage({
            action: 'checkContent',
            ...tabPanelStates.get(tabId),
            target: 'sidePanel',
            tabId
          });
        }, 300);
      });
  } else if (request.action === 'saveCheckResult') {
    // 保存检测结果
    const tabId = request.tabId;
    if (tabId && tabPanelStates.has(tabId)) {
      const state = tabPanelStates.get(tabId);
      state.resultList = request.resultList;
      state.resultListAll = request.resultListAll;
      state.statisticsList = request.statisticsList;
      state.checked = true; // 标记为已检测
      tabPanelStates.set(tabId, state);
    }
  }
});

// 标签页关闭时清理状态
chrome.tabs.onRemoved.addListener(tabId => {
  tabPanelStates.delete(tabId);
});

// 标签页切换时更新侧板内容
chrome.tabs.onActivated.addListener(activeInfo => {
  const tabState = tabPanelStates.get(activeInfo.tabId);
  
  if (tabState) {
    // 如果该标签页有数据，发送数据到侧板
    chrome.runtime.sendMessage({
      action: 'checkContent',
      ...tabState,
      target: 'sidePanel',
      tabId: activeInfo.tabId
    });
  } else {
    // 如果该标签页没有数据，发送空数据到侧板
    chrome.runtime.sendMessage({
      action: 'checkContent',
      text: '',
      isTextarea:true,
      resultList: [],
      resultListAll: [],
      statisticsList: [],
      hasContent: false,
      target: 'sidePanel',
      tabId: activeInfo.tabId
    });
  }
});